	function Cost = EQ_AP_LP_Z(X, Nap)
	
	% 	Cost function for equalization of a digital lowpass filer 
	%	with an allpass function of order Nap.  
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-21
    % 	Modified by:		 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1	
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	global p TgH Wpas points
	Pap = EQ_PARAM_P_Z(X, Nap); % Convert real parameters, X, to poles
	% Make sure that all poles are inside the unit circle
	for n = 1:length(Pap)
		if abs(Pap(n)) >= 1	
			Pap(n) = Pap(n)/(abs(Pap(n))+0.001);
		end
	end
	Taug = PZ_2_TG_Z(1, 1./Pap, Pap, Wpas);
	Tg0 = sum(Taug + TgH)/points; 
	Cost = sum((Taug +TgH - Tg0).^p);
	return
	
